@extends('layouts.master')
@section('title',__('Create Fake View'))
@section('breadcum')
	<div class="breadcrumbbar">
    <h4 class="page-title">{{ __('Create Fake View') }}</h4>
    <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
          <li class="breadcrumb-item active" aria-current="page">{{ __('Create Fake View') }}</li>
        </ol>
    </div> 
  </div>
@endsection
@section('maincontent')
<div class="contentbar">
  <div class="row">
    @if ($errors->any())  
      <div class="alert alert-danger" role="alert">
        @foreach($errors->all() as $error)     
          <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
          <span aria-hidden="true" style="color:red;">&times;</span></button></p>
        @endforeach  
       </div>
    @endif
    <div class="col-lg-12">
      <div class="card m-b-30">
        <div class="card-header">
          <a href="{{url('admin/fakeViews')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Back') }}"><i
            class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a>
          <h5 class="box-title">{{__('Create Fake Views')}}</h5>
        </div>
        <div class="card-body ml-2">
            {!! Form::open(['method' => 'POST', 'action' => 'FakeSeasonViewController@store', 'files' => true]) !!}
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group text-dark{{ $errors->has('feature') ? ' has-error' : '' }}">
                        {!! Form::label('feature',__('Select Movie')) !!} 
                        <small class="badge badge-pill badge-secondary" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{ __('Please Select movie')}}">
                          <i class="fa fa-info"></i>
                        </small>
                        <select class="select2 form-control" name="series_id" required>
                          @foreach($series as $data)
                            <option value="{{$data->id}}">{{$data->tvseries['title'] }} [Season: {{ $data->season_no }}</option>
                          @endforeach
                        </select>
                        
                        <small class="text-danger">{{ $errors->first('series') }}</small>
                    </div>
                  </div>
                <div class="col-md-2">
                    <div class="form-group ">
                      {!! Form::label('views', __('Add No. of Fake View')) !!} <sup class="text-danger">*</sup> <small class="badge badge-pill badge-secondary" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{ __('Add Number of fake views you want to add in particular Movie.')}}">
                          <i class="fa fa-info"></i>
                      </small>
                      {!! Form::number('views', old('views'), ['class' => 'form-control','autocomplete'=>'off','required']) !!}
                    </div>
                  </div>
                <div class="col-md-12">
                <div class="form-group">
                  <button type="submit" class="btn btn-primary-rgba" title="{{ __('Create') }}"><i class="fa fa-check-circle"></i>
                    {{ __('Create') }}</button>
                </div>
              </div>
            </div>
            {!! Form::close() !!}
            <div class="clear-both"></div>           
  
          </div>
      </div>
    </div>
  </div>
</div>
@endsection 
@section('script')
<script>
  (function($){
    $.noConflict();    
  })(jQuery);    
</script>  
@endsection